<?php
// create_superadmin.php
// Script temporal para crear/actualizar un usuario SUPERADMIN en la tabla users.
// IMPORTANTE: Ejecuta una sola vez y luego BORRA este archivo del servidor.

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// ============ CONFIGURA AQUÍ LOS DATOS DEL SUPERADMIN ============

// Usuario para login (se guarda en la columna "phone")
$username = 'superadmin';

// Nombre que verás en el panel
$name     = 'Super Administrador';

// Contraseña que usará para entrar al panel
$password = 'SuperAdmin.2025';

// Dirección opcional
$address  = 'Oficinas Blanquita';

// Código postal opcional
$cp       = '78399';

// ===========================================================

try {
    $pdo = pdo();

    // ¿Ya existe un usuario con ese "usuario"?
    // NOTA: usamos la columna phone como "usuario / login"
    $stmt = $pdo->prepare("SELECT id, name, role FROM users WHERE phone = ? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        // No existe: lo registramos usando la función estándar
        register_user($name, $username, $address, $password, $cp);

        // Forzamos rol superadmin y activamos
        $upd = $pdo->prepare("
            UPDATE users
               SET role = 'superadmin',
                   is_active = 1
             WHERE phone = ?
        ");
        $upd->execute([$username]);

        echo "<h2>Superadmin creado correctamente</h2>";
        echo "<p>Usuario: <strong>" . htmlspecialchars($username, ENT_QUOTES, 'UTF-8') . "</strong></p>";
    } else {
        // Ya existía: actualizamos contraseña, nombre, rol e is_active
        $hash = password_hash($password, PASSWORD_DEFAULT);

        $upd = $pdo->prepare("
            UPDATE users
               SET name          = ?,
                   address       = ?,
                   postal_code   = ?,
                   password_hash = ?,
                   role          = 'superadmin',
                   is_active     = 1
             WHERE phone = ?
        ");
        $upd->execute([$name, $address, $cp, $hash, $username]);

        echo "<h2>Superadmin actualizado correctamente</h2>";
        echo "<p>Usuario: <strong>" . htmlspecialchars($username, ENT_QUOTES, 'UTF-8') . "</strong></p>";
    }

    echo "<p>Ahora puedes usar este usuario para entrar al panel <code>userAdd.php</code> (cuando adaptemos el login del panel a DB).</p>";
    echo "<p><strong>IMPORTANTE:</strong> cuando confirmes que ya funciona, borra el archivo <code>create_superadmin.php</code> del servidor.</p>";

} catch (Throwable $e) {
    http_response_code(500);
    echo "<h2>Error creando superadmin</h2>";
    echo "<pre>" . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8') . "</pre>";
}
