<?php
// export_historial.php
// Exporta historial de pedidos a Excel (una fila por ARTÍCULO)

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

$u = current_user();
if (!$u || !in_array($u['role'], ['ventas','admin'], true)) {
    http_response_code(403);
    echo 'No autorizado.';
    exit;
}

$desde = trim($_GET['desde'] ?? '');
$hasta = trim($_GET['hasta'] ?? '');

if ($desde === '' || $hasta === '') {
    echo 'Faltan parámetros de fecha (desde / hasta).';
    exit;
}

// Rango de día completo
$desdeFull = $desde . ' 00:00:00';
$hastaFull = $hasta . ' 23:59:59';

$pdo = pdo();

// ========= CONSULTA: UNA FILA POR ITEM =========
$stmt = $pdo->prepare("
    SELECT
        o.id                        AS id_pedido,
        o.created_at,
        o.sales_order,
        o.delivery_date,
        o.delivery_address          AS address,
        o.status,
        u.name                      AS cliente,
        u.phone                     AS phone,
        p.name                      AS producto,
        oi.quantity                 AS cantidad
    FROM orders o
    JOIN users u
      ON u.id = o.customer_id
    JOIN order_items oi
      ON oi.order_id = o.id
    JOIN products p
      ON p.id = oi.product_id
    WHERE o.created_at BETWEEN ? AND ?
    ORDER BY o.created_at DESC, o.id ASC, p.name ASC
");
$stmt->execute([$desdeFull, $hastaFull]);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// ========= SALIDA COMO "EXCEL" (HTML) =========
$filename = 'historial_pedidos_' . $desde . '_a_' . $hasta . '.xls';

header('Content-Type: application/vnd.ms-excel; charset=utf-8');
header('Content-Disposition: attachment; filename="'.$filename.'"');
header('Pragma: no-cache');
header('Expires: 0');

// BOM para UTF-8
echo "\xEF\xBB\xBF";

echo "<table border='1'>\n";
echo "<thead>\n<tr>";
echo "<th>Fecha alta</th>";
echo "<th>Pedido</th>";
echo "<th>OC</th>";
echo "<th>Cliente</th>";
echo "<th>Teléfono</th>";
echo "<th>Dirección</th>";
echo "<th>Producto</th>";
echo "<th>Cantidad</th>";
echo "<th>Estatus</th>";
echo "<th>Fecha entrega</th>";
echo "</tr>\n</thead>\n<tbody>\n";

if ($rows) {
    foreach ($rows as $r) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($r['created_at'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars('#'.$r['id_pedido'], ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['sales_order'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['cliente'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['phone'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['address'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['producto'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['cantidad'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['status'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "<td>" . htmlspecialchars($r['delivery_date'] ?? '', ENT_QUOTES, 'UTF-8') . "</td>";
        echo "</tr>\n";
    }
} else {
    echo "<tr><td colspan='10'>Sin registros en el rango seleccionado.</td></tr>\n";
}

echo "</tbody>\n</table>";
exit;
