<?php
// Parche para servidores donde php_uname() está deshabilitada.
// Twilio SDK llama php_uname() dentro del namespace Twilio\Base.

namespace Twilio\Base {
  if (!function_exists(__NAMESPACE__ . '\\php_uname')) {
    function php_uname($mode = 'a') {
      // Intentar global si existe (en algunos host está deshabilitada)
      if (function_exists('\\php_uname')) {
        try { return \php_uname($mode); } catch (\Throwable $e) {}
      }
      return 'unknown';
    }
  }
}

namespace { /* vuelve al namespace global */ }
