<?php
// wa_worker.php
// Procesa la cola de WhatsApp (wa_outbox). Ideal para cron.
// PHP 8.1+

declare(strict_types=1);

// Polyfill opcional (si existe en tu proyecto)
$poly = __DIR__ . '/includes/twilio_polyfill.php';
if (is_file($poly)) {
    require_once $poly;
}

require_once __DIR__ . '/includes/db.php';

$waHelper = __DIR__ . '/whatsapp_helper.php';
if (is_file($waHelper)) {
    require_once $waHelper;
}

$waOutbox = __DIR__ . '/includes/wa_outbox.php';
if (is_file($waOutbox)) {
    require_once $waOutbox;
}

// Salida entendible en web/CLI
if (PHP_SAPI !== 'cli') {
    header('Content-Type: text/plain; charset=utf-8');
    header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
    header('Pragma: no-cache');
}

if (!function_exists('wa_process_outbox')) {
    echo "[WA] wa_outbox.php no disponible o no cargó funciones.\n";
    exit(0);
}

try {
    $pdo = pdo();
} catch (Throwable $e) {
    echo "[WA] DB_ERROR: " . $e->getMessage() . "\n";
    exit(1);
}

// Límite por corrida (CLI: primer argumento, Web: ?limit=)
$limit = 20;
if (PHP_SAPI === 'cli') {
    global $argv;
    if (!empty($argv[1])) $limit = (int)$argv[1];
} else {
    if (isset($_GET['limit'])) $limit = (int)$_GET['limit'];
}
$limit = max(1, min(200, $limit));

$res = wa_process_outbox($pdo, $limit);

echo "[WA] processed=" . ($res['processed'] ?? 0)
   . " sent=" . ($res['sent'] ?? 0)
   . " failed=" . ($res['failed'] ?? 0)
   . " skipped=" . ($res['skipped'] ?? 0)
   . "\n";

if (!empty($res['errors'])) {
    foreach ($res['errors'] as $err) {
        echo "[WA][ERR] {$err}\n";
    }
}
